import 'package:app_links/app_links.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:wordpress_app/pages/future_article_details.dart';
import 'package:wordpress_app/utils/next_screen.dart';

class AppLinksService {
  Future<void> initUniLinks(BuildContext context) async {
    try {
      final initialLink = await AppLinks().getInitialLinkString();
      if (!context.mounted) return;
      handleLinks(context, initialLink);
    } on PlatformException {
      debugPrint('platform error');
    }
  }

  Future<void> handleLinks(BuildContext context, String? initialLink) async {
    if (initialLink != null) {
      debugPrint('has link: $initialLink');
      final url = Uri.parse(initialLink);
      String slug = url.path.trim();

      // Remove leading slash if present
      if (slug.startsWith('/')) {
        slug = slug.substring(1);
      }

      // Check if it's homepage or empty slug
      if (slug.isEmpty || slug == '/') {
        debugPrint('Homepage link detected, staying on current page');
        return;
      }

      Future.delayed(const Duration(milliseconds: 100)).then((value) {
        if (!context.mounted) return;
        nextScreen(
          context,
          FutureArticleDetails(
            postID: null,
            fromNotification: false,
            slug: slug,
          ),
        );
      });
    } else {
      debugPrint('no links found');
    }
  }
}
